# -*- coding: utf-8 -*-
"""
Created on Mon Apr  4 11:51:46 2016

@author: jacksonudy
"""

from apm import *
import matplotlib.pyplot as plt

## continuous time simulation
s = 'http://byu.apmonitor.com'
a = 'CRMOPT2'

# Problem Setup
apm(s,a,'clear all')
apm_load(s,a,'CRM_FFM.apm')
csv_load(s,a,'scheme2.csv')
# Global settings
apm_option(s,a,'nlc.imode',6)      # Solve mode (6 = Optimization, 4 = Simulation)
apm_option(s,a,'nlc.nodes',3)      # Number of collocation nodes
apm_option(s,a,'nlc.solver',1)     # Solver: Try IPOPT later (3)
#apm_option(s,a,'nlc.max_iter', 10)   # Attempt to solve quicker at the expense of solution optimality

# controller setup
# manipulated variables
apm_info(s,a,'MV','inj1')
apm_info(s,a,'MV','inj2')
apm_option(s,a,'inj1.status',1)
apm_option(s,a,'inj2.status',1)

# State Variable Declaration
apm_info(s,a,'SV','q11')
apm_info(s,a,'SV','q12')
apm_info(s,a,'SV','q21')
apm_info(s,a,'SV','q22')
apm_info(s,a,'SV','q1')
apm_info(s,a,'SV','q2')
apm_info(s,a,'SV','prod1water')
apm_info(s,a,'SV','prod2water')
apm_info(s,a,'SV','CWI')
apm_info(s,a,'SV','prod1oil')
apm_info(s,a,'SV','prod2oil')

# controlled variables
apm_info(s,a,'CV','TotalProduction')
#apm_option(s,a,'product.status',1)
#apm_option(s,a,'product.fstatus',1)

## MV tuning
# lower and upper bounds for MV's
apm_option(s,a,'inj1.lower',0)
apm_option(s,a,'inj2.lower',0)

# solve
solution = apm(s,a,'solve')
print solution

# retrieve solution
z = apm_sol(s,a)

# open web viewer
apm_web(s,a)